clear all
clc
close all


%% Create Data

load AALabData
Y=Action;
indne=IndNE;
features=FeaturesAct;
Row=row;
Column=column;
clear row column

load AANewData

Y=[Y;modal'];
indne=[indne;IndNE];
features=[features;FeaturesAct];
Row=[Row;row'];
Column=[Column; column'];
clear row column

load AAMTData
m=length(row);
YMT=zeros(1,m);
for i=1:m
    YMT(i)=modal{i}(1); 
end
Y=[Y;YMT'];
indne=[indne;IndNE];
features=[features;FeaturesAct];
Row=[Row;row];
Column=[Column; column];
clear row column

X=features;

M=100; % number of repetitions
nnerror=zeros(1,M);
for m=1:M
    Z=zeros(486,3);
    for i=1:486
        for j=1:3
            if Y(i)==j
                Z(i,j)=1;
            end
        end
    end
    
    x = X';
    t = Z';
    trainFcn = 'trainscg';  % Scaled conjugate gradient backpropagation.
    
    % Create a Pattern Recognition Network
    hiddenLayerSize = 10;
    net = patternnet(hiddenLayerSize);
    
    % Setup Division of Data for Training, Validation, Testing
    net.divideParam.trainRatio = 70/100;
    net.divideParam.valRatio = 15/100;
    net.divideParam.testRatio = 15/100;
    
    % Train the Network
    [net,tr] = train(net,x,t);
    
    % Test the Network
    y = net(x);
    e = gsubtract(t,y);
    performance = perform(net,t,y);
    tind = vec2ind(t);
    yind = vec2ind(y);
    nnerror(m) = sum(tind ~= yind)/numel(tind);
end

'2-Layer Neural Net'
1-mean(nnerror)
sqrt(var(nnerror))